/* production data for Wave 1; includes all revisions made to components
of value added and capital stock for Revision Mar2000 of data */

libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';


/* ****************************************** */
/* setting up firm characteristics for Wave 1 */
/* ****************************************** */

data common; set tz.tz123;
options nolabel;
firm=key;
keep firm indu indu_1 indu_2 indu_3
loca loca_1 loca_2 loca_3 owner_1 owner_2
owner_3 sect sect_1 sect_2 sect_3;
proc sort; by firm;

data temp1; set common;
if indu_1=. then delete;
proc sort; by firm;


data temp2; set tz.tz1new;
options nolabel;
firm=key;
wave=1;
name=v01nam1;

proc sort; by firm;

data size1; merge temp1 temp2; by firm;

/* industrial sector */
if indu=1 then indlab='food';
if indu=2 then indlab='textile';
if indu=3 then indlab='wood';
if indu=4 then indlab='metal';

if indu=1 then food=1; else food=0;
if indu=2 then text=1; else text=0;
if indu=3 then wood=1; else wood=0;
if indu=4 then metal=1; else metal=0;

/* type of firm */
if sect=1 then sectlab='informal';
if sect=2 then sectlab='formal';

/* firm size dummies; need to exclude seasonal workers
from calculation of firm employment level to be consistent
with waves 2 and 3 */

empft=v2401f;
emppt=v2401p;
if emppt=. then emppt=0;
empseas=v2402;
if empseas=. then empseas=0;
if empseas gt emppt then empseas=emppt;
emppt=emppt-empseas;
emp=empft+emppt;
if emp=0 then emp=emp+1;
emp92=emp;

if emp ge 1 and emp le 5 then size92=1;
if emp ge 6 and emp le 29 then size92=2;
if emp ge 30 and emp le 99 then size92=3;
if emp ge 100 then size92=4;

if size92=1 then sizedum='amicro';
if size92=2 then sizedum='bsmall';
if size92=3 then sizedum='cmedium';
if size92=4 then sizedum='dlarge';

if size92=1 then micro=1; else micro=0;
if size92=2 then small=1; else small=0;
if size92=3 then medium=1; else medium=0;
if size92=4 then large=1; else large=0;

keep firm wave indu indlab sect sectlab loca
emp emp92 empft emppt empseas size92 sizedum food text wood metal
micro small medium large name;

data cd.w1chars; set size1;
proc sort; by firm;



/* ****************************************** */
/* setting up main firm variables for Wave 1 */
/*          production function              */
/* ****************************************** */
 
data check2; set tz.tz1new;
options linesize=80;
options nolabel;

wave=1;
firm=key;

accts=v0801;
period=v0802;

output=v1010;
sales=v1007;
inctrad=v1008;
incserv=v1009;

/* calculate sales for small firms as check */
if v09105=. then v09105=0;
if v09205=. then v09205=0;
if v09305=. then v09305=0;
if v09405=. then v09405=0;
if v09505=. then v09505=0;
salesb=v09105+v09205+v09305+v09405+v09505;
if sales=. then sales=salesb;

/* more firms report sales than output and sales figure
is more consistent in wave 1 thus use sales figures */
output=sales;
if firm=202 then output=v1010;

rawmat=v1013;

/* calculate raw materials for small firms as check */
if v09106=. then v09106=0;
if v09206=. then v09206=0;
if v09306=. then v09306=0;
if v09406=. then v09406=0;
if v09506=. then v09506=0;
rawmatb=v09106+v09206+v09306+v09406+v09506;
if rawmat=. then rawmat=rawmatb;

rent=v1224a;
elec=v1224b;
water=v1224c;
telef=v1224d;
lfuel=v1224e;
sfuel=v1224f;
advert=v1226;

if rent=. then rent=0;
if elec=. then elec=0;
if water=. then water=0;
if telef=. then telef=0;
if lfuel=. then lfuel=0;
if sfuel=. then sfuel=0;
if advert=. then advert=0;

misc=rent+elec+water+telef+lfuel+sfuel+advert;

wages=v1016;

profit=v1225;

/* section to annualise production data */

if period=1 then output=output;
if period=2 then output=output*2;
if period=3 then output=output*12;
if period=4 then output=output*52/2;
if period=5 then output=output*52;
if period=6 then output=output*260;

if period=1 then sales=sales;
if period=2 then sales=sales*2;
if period=3 then sales=sales*12;
if period=4 then sales=sales*52/2;
if period=5 then sales=sales*52;
if period=6 then sales=sales*260;

if period=1 then rawmat=rawmat;
if period=2 then rawmat=rawmat*2;
if period=3 then rawmat=rawmat*12;
if period=4 then rawmat=rawmat*52/2;
if period=5 then rawmat=rawmat*52;
if period=6 then rawmat=rawmat*260;

if period=1 then misc=misc;
if period=2 then misc=misc*2;
if period=3 then misc=misc*12;
if period=4 then misc=misc*52/2;
if period=5 then misc=misc*52;
if period=6 then misc=misc*260;

if period=1 then wages=wages;
if period=2 then wages=wages*2;
if period=3 then wages=wages*12;
if period=4 then wages=wages*52/2;
if period=5 then wages=wages*52;
if period=6 then wages=wages*260;

if period=1 then profit=profit;
if period=2 then profit=profit*2;
if period=3 then profit=profit*12;
if period=4 then profit=profit*52/2;
if period=5 then profit=profit*52;
if period=6 then profit=profit*260;

/* adjustments to components of VAD made in light of
better information available in subsequent waves */

if firm=29 then rawmat=13344000;
if firm=29 then misc=120000;
if firm=34 then rawmat=508164000;
if firm=76 then rawmat=310474000;
if firm=90 then output=8100000;
if firm=90 then misc=601500;
if firm=90 then rawmat=5554000;
if firm=110 then rawmat=18500000;
if firm=70 then output=output/2;
if firm=70 then rawmat=rawmat/2;


/* calc of total labour costs using firm level monthly
allowances on p.19 of quest */

allfood=v2610a*12;
allhouse=v2610b*12;
allcloth=v2610c*12;
alltrans=v2610d*12;
allbonus=v2610e*12;

if allfood=. then allfood=0;
if allhouse=. then allhouse=0;
if allcloth=. then allcloth=0;
if alltrans=. then alltrans=0;
if allbonus=. then allbonus=0;

labcost=wages+allfood+allhouse+allcloth+alltrans+allbonus;

if labcost=. then labcost=wages;

cap=v1118;
capsale=v1119;
caplb=v1117a;

equip1=v11211;
equip2=v11212;
equip3=v11213;
equip4=v11214;
equip5=v11215;

if equip1=. then equip1=0;
if equip2=. then equip2=0;
if equip3=. then equip3=0;
if equip4=. then equip4=0;
if equip5=. then equip5=0;

capcon=equip1+equip2+equip3+equip4+equip5;
if capcon=0 then capcon=.;

if cap=. then cap=capcon;
if cap=. then cap=capsale;

/* adjustments to cap stock using information
from other waves or using resale value where this seems
more reliable */

if firm=67 then cap=100000;
if firm=214 then cap=1000000;
if firm=413 then cap=75000;
if firm=507 then cap=150000;
if firm=603 then cap=10000000;
if firm=232 then cap=100000000;
if firm=303 then cap=20000000;
if firm=19 then cap=500000;
if firm=21 then cap=15000000;
if firm=220 then cap=1000000;
if firm=304 then cap=350000;
if firm=405 then cap=30000000;
if firm=41 then cap=1600000;
if firm=8 then cap=3000000;
if firm=65 then cap=7400000;
if firm=208 then cap=40000000;
if firm=14 then cap=670000000;
if firm=57 then cap=750000000;
if firm=23 then cap=50000000;
if firm=34 then cap=614000000;  /* resale value */
if firm=514 then cap=15000000000; /* based on W2 figure */
if firm=427 then cap=14000000000;  /* based on W2 figure */
if firm=207 then cap=250000000;  /* based on W2 figure */
if firm=420 then cap=972999000;
if firm=611 then cap=50000000; /* wave 2 resale value */

/* adjustments to make consistent with other waves */
if firm=1 then cap=600687480; /* same ratio to VAD as wave 2 */
if firm=98 then cap=1000000;
if firm=306 then cap=1000000;
if firm=407 then cap=10000000;
if firm=502 then cap=900000;
if firm=65 then cap=37000000;
if firm=92 then cap=160000000;
if firm=425 then cap=200000000;
if firm=620 then cap=108554000;

/* employment total, need to exclude seasonal workers */
empft=v2401f;
emppt=v2401p;
if emppt=. then emppt=0;

empseas=v2402;
if empseas=. then empseas=0;

if empseas gt emppt then empseas=emppt;
emppt=emppt-empseas;

emp=empft+emppt;

if emp=0 then emp=emp+1;
if firm=70 then emp=3;
if firm=83 then emp=2;

/* constructed variables and key ratios */

capemp=cap/emp;
vad=output-misc-rawmat;
prcalc=vad-labcost;
prate=profit/cap;
vademp=vad/emp;
vadcap=vad/cap;
capvad=cap/vad;

exppc=v1231;
if exppc=. then exppc=0;
if exppc ne 0 then expdum=1; else expdum=0;

output92=output;
sales92=sales;
rawmat92=rawmat;
misc92=misc;
wages92=wages;
labc92=labcost;
cap92=cap;
capsal92=capsale;
emp92=emp;
vad92=vad;
prof92=profit;
expdum92=expdum;
exppc92=exppc;
capemp92=capemp;
vademp92=vademp;
vadcap92=vadcap;
capvad92=capvad;
prate92=prate;
prcalc92=prcalc;

/* firms excluded from vad calculations due to missing or
unreliable data */

if firm=5 then delete;
if firm=10 then delete;
if firm=15 then delete;
if firm=43 then delete;
if firm=54 then delete;
if firm=87 then delete;
if firm=213 then delete;
if firm=225 then delete; /* tourism firm */
if firm=526 then delete; /* data poor & inconsistent */
if firm=610 then delete; /* exclude in all waves */


keep firm wave accts period output sales inctrad incserv
rawmat misc wages labcost cap capsale caplb capcon emp empft emppt capemp
vad vademp vadcap capvad profit prate prcalc exppc expdum
output92 sales92 rawmat92 misc92 wages92 labc92 cap92 capsal92
emp92 vad92 prof92 expdum92 exppc92 capemp92 vademp92
vadcap92 capvad92 prate92 prcalc92;




/* to eliminate firms with negative VAD from calculations
data check3; set check2;
if vad gt 0;
proc means; run;
*/


/* creates permanent data file with gen firm variables for Wave 1
and includes additional cleaning to make consistent with Wave 4 */

data cd.genfirm1; merge check2 (in=a) size1; by firm; if a;
proc means; run;

/* proc print; var firm wave output vad cap emp; run; */

/* production function for Wave 1 */

data check4; set check2;
options nolabel;

if vad lt 0 then delete;
if vadcap gt 50 then delete;
if capvad gt 100 then delete;

lvad=log(vad);
lemp=log(emp);
lcap=log(cap);

proc means; var firm vad emp cap vadcap capvad; run;
proc reg; model lvad=lcap lemp;
run;

/* cross-tabulations on key firm characteristics */

data temp3a; merge check2 (in=a) size1; by firm; if a;

proc means; var firm emp cap output vad capemp vademp
capvad vadcap; run;

proc sort; by indlab;
proc means; var firm emp cap output vad capemp vademp
capvad vadcap; by indlab; run;

proc sort; by sizedum;
proc means; var firm emp cap output vad capemp vademp
capvad vadcap; by sizedum; run;

proc sort; by sect;
proc means; var firm emp cap output vad capemp vademp
capvad vadcap; by sect; run;


